
function AISMN_FirePanic::OnEnter(%this, %data)
{
   %tar = GetParameterTarget(%data);
   if (%tar == 0)
   {
      SetVariable(%data,0,1);
      return;
   }
   
   %object = GetThisObject(%data);
   %object.playThread(0, "panic");
   
   %diff = 5;
   %doorX = GetBuildingDoorX(%tar);
   %doorY = GetBuildingDoorY(%tar);
   if (SetPathForRandomLocation(%data, %doorX - %diff, %doorY - %diff,
      %doorX + %diff, %doorY + %diff) == false)
   {
      SetStateVariable(%data, 0, 1);
      return;
   }
   
   // unmount any objects attached to the character's hands
   %object.unmountImage(1);
   %object.unmountImage(2);
   %object.unmountImage(3);
}

function AISMN_FirePanic::OnExit(%this, %data)
{
   %object = GetThisObject(%data);
   %object.playThread(0, "root");
   
   StopMoving(%data);
   
   // only restore props if the building is no longer on fire
   %target = GetParameterTarget(%data);
   %component = slgQueryInterface(%target, $CID_BUILDING);
   if (%component.onFire() == false)
   {
      RestoreCharacterOutfit(%data);
   }
}

//EXIT 0: DONE PANICKING (Building is no longer on fire)
function AISMN_FirePanic::Update(%this, %data)
{
   if (GetStateVariable(%data, 0) > 0)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   //Get the building component and target
   %tar = GetParameterTarget(%data);
   %component = slgQueryInterface(%tar, $CID_BUILDING);
   if (0 == %tar || 0 == %component)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   if (%component.onFire() == false)
   {
      ReturnValue(%data, 0);
      return;
   }
   
   if (!IsFollowingPath(%data))
   {
      ReturnValue(%data, 1);
      return;
   }
   
   //Stay in this state
   ReturnValue(%data, -1);
}
